//
//  ViewController.m
//  Searching for Files and Folders in iCloud
//
//  Created by Vandad Nahavandipoor on 17/09/2011.
//  Copyright (c) 2011 Pixolity Ltd. All rights reserved.
//

#import "ViewController.h"

@implementation ViewController

@synthesize metadataQuery;

- (void)didReceiveMemoryWarning
{
  [super didReceiveMemoryWarning];
  // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

#pragma mark - Cykl życiowy widoku

- (NSURL *) urlForDocumentsFolderIniCloud{
  
  NSURL *result = nil;
  
  /* Miejsce na Twój identyfikator Team ID. */
  NSString *teamID = @"TEAM ID";
  
  NSString *containerID = [[NSBundle mainBundle] bundleIdentifier];
  
  NSString *teamIDAndContainerID = [[NSString alloc] initWithFormat:@"%@.%@", teamID, containerID];
  
  NSFileManager *fileManager = [[NSFileManager alloc] init];
  
  NSURL *appiCloudContainerURL = 
  [fileManager URLForUbiquityContainerIdentifier:teamIDAndContainerID];
  
  result = [appiCloudContainerURL URLByAppendingPathComponent:@"Documents"
                                                  isDirectory:YES];
  
  if ([fileManager fileExistsAtPath:[result path]] == NO){
    
    /* Katalog Documents NIE istnieje w kontenerze aplikacji umieszczonym w usłudze iCloud.
      Spróbujemy go teraz utworzyć. */
    
    NSError *creationError = nil;
    BOOL created = [fileManager createDirectoryAtURL:result
                         withIntermediateDirectories:YES
                                          attributes:nil
                                               error:&creationError];
    
    if (created){
      NSLog(@"Udało się utworzyć katalog Documents w usłudze iCloud.");
    } else {
      NSLog(@"Nie udało się utworzyć katalogu Documents w usłudze iCloud. Błąd = %@",
            creationError);
      result = nil;
    }
    
  } else {
    /* Katalog Documents już istnieje w kontenerze aplikacji umieszczonym w usłudze iCloud.
      Nie trzeba więc podejmować żadnych kroków. */
  }
  
  return result;
  
}

- (NSURL *) urlForRandomFileInDocumentsFolderIniCloud{
  
  NSURL *result = nil;
  
  NSUInteger randomNumber = arc4random() % NSUIntegerMax;
  
  NSString *randomFileName = [[NSString alloc] initWithFormat:@"%llu.txt",
                              (unsigned long)randomNumber];
  
  /* Sprawdzenie w zapytaniu metadanych, czy dany plik istnieje. */
  __block BOOL fileExistsAlready = NO;
  [self.metadataQuery.results enumerateObjectsUsingBlock:
   ^(NSMetadataItem *item, NSUInteger idx, BOOL *stop) {
     NSString *itemFileName = [item valueForAttribute:NSMetadataItemFSNameKey];
     if ([itemFileName isEqualToString:randomFileName]){
       NSLog(@"Plik już istnieje. Anuluję operację...");
       fileExistsAlready = YES;
       *stop = YES;
     }
   }];
  
  if (fileExistsAlready){
    return nil;
  }
  
  result = [[self urlForDocumentsFolderIniCloud] 
            URLByAppendingPathComponent:randomFileName];
  
  return result;
  
}

- (NSURL *) urlForRandomFileInDocumentsFolderInAppSandbox
            :(NSString *)paramFileName{
  
  NSURL *result = nil;
  
  NSString *documentsFolderInAppSandbox = 
  [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, 
                                       NSUserDomainMask, 
                                       YES) objectAtIndex:0];
  
  NSString *filePath = [documentsFolderInAppSandbox 
                        stringByAppendingPathComponent:paramFileName];
  
  result = [NSURL fileURLWithPath:filePath];
  
  return result;
  
}

- (void) enumerateMetadataResults:(NSArray *)paramResults{
  
  [paramResults enumerateObjectsUsingBlock:
   ^(NSMetadataItem *item, NSUInteger index, BOOL *stop) {
     
     NSString *itemName = [item valueForAttribute:NSMetadataItemFSNameKey];
     NSURL *itemURL = [item valueForAttribute:NSMetadataItemURLKey];
     NSNumber *itemSize = [item valueForAttribute:NSMetadataItemFSSizeKey];
     
     NSLog(@"Nazwa elementu = %@", itemName);
     NSLog(@"Adres URL utworu = %@", itemURL);
     NSLog(@"Wielkość elementu = %llu", 
           (unsigned long long)[itemSize unsignedLongLongValue]);
     
   }];
  
}

- (void) handleMetadataQueryFinished:(id)paramSender{
  
  NSLog(@"Wyszukiwanie zakończone");
  
  if ([[paramSender object] isEqual:self.metadataQuery] == NO){
    NSLog(@"Nieznany obiekt wywołał tę metodę. Kontynuowanie operacji jest niebezpieczne.");
    return;
  }
  
  /* Zaprzestanie nasłuchiwania powiadomień, ponieważ nie spodziewamy się żadnych kolejnych elementów. */
  [[NSNotificationCenter defaultCenter] removeObserver:self];
  
  /* Zakończenie pracy żądania, przystępujemy do przetworzenia wyników jego działania. */
  [self.metadataQuery disableUpdates];
  [self.metadataQuery stopQuery];
  
  [self enumerateMetadataResults:self.metadataQuery.results];
  
  if ([self.metadataQuery.results count] == 0){
    NSLog(@"Nie znaleziono żadnych plików.");
  }
  
  NSURL *urlForFileIniCloud = [self urlForRandomFileInDocumentsFolderIniCloud];
  
  if (urlForFileIniCloud == nil){
    NSLog(@"Nie można utworzyć pliku we wskazanym adresie URL. Adres URL jest pusty.");
    return;
  }
  
  NSString *fileName = [[[urlForFileIniCloud path] 
                         componentsSeparatedByString:@"/"] lastObject];
  
  NSURL *urlForFileInAppSandbox = 
  [self urlForRandomFileInDocumentsFolderInAppSandbox:fileName];
  
  NSString *fileContent = 
  [[NSString alloc] initWithFormat:@"Content of %@",
   [[self urlForRandomFileInDocumentsFolderIniCloud] path]];
  
  /* Tymczasowe zapisanie pliku w aplikacji, a następnie jego przeniesienie do usługi iCloud. */
  NSError *writingError = nil;
  BOOL couldWriteToAppSandbox = 
  [fileContent writeToFile:[urlForFileInAppSandbox path]
                atomically:YES
                  encoding:NSUTF8StringEncoding
                     error:&writingError];
  
  /* Jeżeli nie można zapisać pliku, po prostu kończymy działanie metody, ponieważ jej
   jej dalsze działanie nie ma żadnego sensu. W idealnej sytuacji plik zostanie przeniesiony
   z aplikacji do usługi iCloud, ale jeśli wystąpił błąd, nie można kontynuować tej operacji. */
  if (couldWriteToAppSandbox == NO){
    NSLog(@"Nie udało się zapisać pliku w aplikacji. Błąd = %@", writingError);
    return;
  }
  
  NSFileManager *fileManager = [[NSFileManager alloc] init];
  
  /* Przeniesienie pliku do usługi iCloud. */
  NSError *ubiquitousError = nil;
  BOOL setUbiquitousSucceeded = 
  [fileManager setUbiquitous:YES
                   itemAtURL:urlForFileInAppSandbox
              destinationURL:urlForFileIniCloud
                       error:&ubiquitousError];
  
  if (setUbiquitousSucceeded){
    NSLog(@"Udało się przenieść plik do usługi iCloud.");
    /* Plik został przeniesiony z aplikacji do usługi iCloud. */
  } else {
    NSLog(@"Nie udało się przenieść pliku do usługi iCloud z powodu błędu = %@", 
          ubiquitousError);
  }
  
}

- (void)viewDidLoad{
  
  [super viewDidLoad];
  
  /* Nasłuchiwanie powiadomienia generowanego, gdy zapytanie metadanych
   zakończy wyszukiwanie wskazanego elementu. */
  [[NSNotificationCenter defaultCenter] 
   addObserver:self
   selector:@selector(handleMetadataQueryFinished:)
   name:NSMetadataQueryDidFinishGatheringNotification
   object:nil];
  
	// Wszelka konfiguracja dodatkowa po wczytaniu widoku, najczęściej z pliku nib.
  self.metadataQuery = [[NSMetadataQuery alloc] init];
  NSArray *searchScopes = [[NSArray alloc] initWithObjects:
                           NSMetadataQueryUbiquitousDocumentsScope, nil];
  [self.metadataQuery setSearchScopes:searchScopes];
  NSPredicate *predicate = [NSPredicate predicateWithFormat:
                            @"%K like %@", 
                            NSMetadataItemFSNameKey,
                            @"*"];
  [self.metadataQuery setPredicate:predicate];
  if ([self.metadataQuery startQuery]){
    NSLog(@"Udało się rozpocząć wykonywanie żądania.");
  } else {
    NSLog(@"Nie udało się rozpocząć wykonywania żądania.");
  }
}

- (void)viewDidUnload{
  [super viewDidUnload];
  //  Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego.
  [[NSNotificationCenter defaultCenter] removeObserver:self];
  [self setMetadataQuery:nil];
}

- (void)viewWillAppear:(BOOL)animated
{
  [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
  [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
  [super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
  [super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
  // Zwrot wartości YES dla obsługiwanych układów.
  if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
  } else {
    return YES;
  }
}

@end
